/**
 * Modify CreateColorMatrix() so we can read its values.
 * use .update() to re-create a CM:
 *   var cm = CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0);
 *   cm.rn=255; // modify the basic color red, but the colormatrix will not change.
 *   cm = cm.update(); // Update the native ColorMatrix using the modified values
 *   ColorArray = cm.getColorArray(); // We can actually save this ColorArray
 *   cm2 = CreateColorMatrix.apply(null, ColorArray); // Transfer the colors into another colormatrix
 */
if(typeof CreateColorMatrix_== 'undefined'){
	CreateColorMatrix_ = CreateColorMatrix;
	CreateColorMatrix = function(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb){
		var o = CreateColorMatrix_(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);
		o.rn=rn; o.rr=rr; o.rg=rg; o.rb=rb;
		o.gn=gn; o.gr=gr; o.gg=gg; o.gb=gb;
		o.bn=bn; o.br=br; o.bg=bg; o.bb=bb;
		o.update = function(){
			return CreateColorMatrix(this.rn, this.rr, this.rg, this.rb,  this.gn, this.gr, this.gg, this.gb,  this.bn, this.br, this.bg, this.bb);
		};
		o.getColorArray = function(){
			return [this.rn, this.rr, this.rg, this.rb,  this.gn, this.gr, this.gg, this.gb,  this.bn, this.br, this.bg, this.bb];
		};
		o.toJSON = function(){}; //TODO
		return o;
	};
};


function calcLevel(exp){
	if(exp<100) return 1;
	if(exp<300) return 2;
	if(exp<600) return 3;
	if(exp<1000) return 4;
	if(exp<1500) return 5;

}

function PersonObj(o) {
	if(this instanceof PersonObj == false){ return new PersonObj(o); };
	this.name = '???';
	this.STATS = {
		hp: 100,
		mp : 0,
		ki : 0,
		experience : 0, //exp
		agility : 10, // speed
		strength: 1, //attack
		charisma: 0,
		luck : 1,
		defense : 1,
		max: {
			hp: 100,
			ki: 5,
			mp: 0
		}
	};
	this.GEAR = {
		1:false,
		2:false,
		4:false,
		8:false,
		16:false,
		32:false,
		64:false,
		128:false
	};

	if(o) inject.call(this, o);

};


function ITEMEngine() {

	if(this instanceof ITEMEngine == false) {
                return new ITEMEngine();
        }

	// Hold all available items
	this.LIST = {};
	this.length = 0;

	var that = this;


	// Body parts & Equipment
	this.GEAR = {
		HEAD:  1,
		TORSO: 2, ARMOUR:2,
		RIGHTARM:4, WEAPON:4,
		LEFTARM:8, SHIELD:8,
		LEGS: 16,
		FEET: 32,
		HALO: 64
	};

	// Item types:
	this.TYPE = {
		Item: 1,
		Food: 2,
		Armour: 4,
		Weapon: 8,
		Projectile: 16,
		Scroll: 32,
		Spell: 64,
		Technique: 128,
		Coin: 256,
		Key: 512
	};

	this.MATERIAL = {
		unknown: 0,
		wood: 1,
		iron: 2,
		steel: 4,
		paper: 8,
		leather: 16,
		rock: 32,
		wind: 64,
		earth: 128,
		fire: 256,
		water: 512,
		cloth: 1024,
		crystal: 2048
	};

	this.BackPack = function(o) {
		if(this instanceof ITEM.BackPack == false){ return new this.BackPack(o); };
		this['_'] = { weight: 0, maxweight:10, items:0, maxitems:10 };

		if(o) inject.call(this, o);
		return this;
	};


	this.Action = {
		'eat' : function(item,sprite){
			LL.write("eating.."+item.name+" have"+item.amount);
			if(item.amount==0)return false;
			item.amount--;
			LL.write("sprite="+FoldObj(sprite.STATS)+"adding item="+FoldObj(item.STATS));
			inject.call(sprite.STATS, item.STATS, "+");
			LL.write("sprite2="+FoldObj(sprite.STATS));
			inject.call(sprite.STATS, sprite.STATS.max, "<");
			LL.write("sprite3="+FoldObj(sprite.STATS));
		},
		'show' : function(){
			LL.write(this.type+": "+this.name+", "+this.desc);
		},
		'use' : function(){
		},
		'getname' : function(sprite){return this.name},
		'throw': function(sprite, who){this.amount--; who.HP -= this.damage},
		'discard': function(){this.amount--;if(this.amount==0)delete CURRENT.BackPack[this.name];},
		'cast': function(sprite,who){who.HP+=this.health+this.damage;who.KI+=this.ki},
	        'study': function(sprite){},
        	'equip': function(sprite){}
	};

	this.when = { // negative=disabled action. positive: enabled action.
        	'default': 1, // default actions, not saved into save file. Link from Action_<action>()
        	'save': 2, // non-default actions. saved to save file. Left alone.
		'normal': 4, // action can be performed during normal usage ex: apple.show:1|4,apple.eat:1|4
		'battle': 8, // action can be performed during battle, ex: apple.throw:1|8
		'onobject': 16, // action can be performed on other object    ex:shoeshine.apply [You need to overload this.check() ]
		'onperson': 32, // action can be performed on other person    ex:healspell1.cure, armor1.equip
		'onplaces': 64, // action can be performed in certain places: ex: bucket.fill [You need to overload this.check() ]
		'onoverworld': 128 // action can be performed in the overworld only
		// &256/&512 and up: user definable.
	};

	this.addBackpack= function(backpack, name){
		LL.write("adding in backpack: "+name)
		if(!name) {
			Abort("Adding item without a name "+FoldObj(properties));
		}
		if(backpack[name]){
			if(backpack['_'].weight + backpack[name].weight <= backpack['_'].maxweight){
				LL.write('just summing');
				backpack[name].amount++;
				backpack['_'].weight += backpack[name].weight;
				return true;
			}else{
				LL.write('BACKPACK FULL!');
				return false;
			}
		}else{
			backpack[name]= new this.LIST[name].type(name, this.LIST[name].build);
			for(var i in this.LIST[name].build) {
				if(typeof this.LIST[name].build[i]=='function'){
					backpack[name].action[i]=2;
				}
			}
			backpack[name].that = this.LIST[name].type;
			inject.call( backpack[name], this.LIST[name].build);
			if(backpack['_'].weight + backpack[name].weight <= backpack['_'].maxweight){
				return true;
			}else{
				LL.write('BACKPACK FULL!');
				delete backpack[name];
				return false;
			}
		}
		LL.write('done backpack adding')
	};

	/**
	 * Exampke: ITEM.RegisterItem( ITEM.GenericItem, 'rusty key', {});
	 * Example: ITEM.RegisterItem( ITEM.FoodItem, 'apple' , { STATS: {hp: 5} } );
	 */
	this.RegisterItem= function(type, item, properties){
		if(this.LIST[item]) {
			LL.write("warning: re-adding"+item);
			return false;
		}
		this.LIST[item] = { type:type, build:properties}
		return item;
	};

	this.IsRegistered = function(item){
		return !!this.LIST[item];
	};


	this.GenericItem = function(name, properties) {
		this.name = name;
		this.type = "Item";
		this.weight = 1;  //Important for your BackPack.
		this.material = ''; //If we are in a shop in the woods, we can lower the price of wooden objects.
		this.price = 1; //Important for your budget. <0 when it cant be sold in a shop.
		this.unique = false; //Reliqs cant be thrown away/sold and you can equip only one of them in the whole game.
		this.amount = 1; //Usually one, unless you have Food("eggbox") with 6 eggs.
		this.desc = "Its just a " + name;
		this.rss = "items.rss"; //RSS filename where the item is
		this.icon = name; //rss direction
		this.colormatrix = undefined; //Apply this colormatrix to the icon: Note: this.colormatrix= new ColorMatrix(<colors>);
		this.action = {give:32,show:1,discard:1}; //Default actions. action Functions are linked in object later on.
		this.onCreate =function(){}; //this executes just after creating the item in a map. 
		this.onCreateSeed = 1; //onCreate RandomSeed:with this amount of chance. (value between 0=disabled and 1=always)
		this.onReceive = function(){}; //this executes just after you receive the item.
		this.onReceiveSeed = 1;
		this.onWalking = function(){}; //Cursed/blessed armour runs this while equipped
		this.onWalkingSeed =0;
		this.onBattle = function(){}; //Runs when attacking with this Item. Remember to this.action.magicbattle=2; if redefined.
		this.onBattleSeed = 0; //Armour can retaliate/defend with this function.
		this.PROJECTILE = { damage:1 }; // damage when thrown
		inject.call(this, properties, '=');
	};

	function extend(child, parent) { child.prototype.__proto__ = parent.prototype; };

	this.FoodItem = function(name, properties) {
		LL.write("Adding FoodItem "+name);
		//inject.call(this, new that.GenericItem(name), '=');
		that.GenericItem.call(this, name);
		delete this.desc;
		this.material = 'earth';

		// When eaten
		this.STATS = { hp:1, mp:0, str:1, ev:0, luck:0, cha:0, ki:0 };

		inject.call(this, properties, '=');
		this.name = name;
		this.type = "Food";

		if(!this.desc) this.desc = "Its just a " + name + ". Gives " + this.STATS.hp + " health.";
		this.action= {eat:1|4,"throw":1|8, give:32,show:1,discard:1};
	};
	extend(this.FoodItem, this.GenericItem)

	this.KeyItem = function(name, properties) {
		LL.write("Adding KeyItem "+name);
		inject.call(this, new that.GenericItem(name), '=');
		delete this.desc;
		this.unique = true;
		inject.call(this, properties, '=');
		this.name = name;
		this.type = "Key";
		if(!this.desc) this.desc = "Its just a " + name + ". It probably will open a door somewhere."
		
		if(this.unique){
			this.action= {use:1|4, give:32, show:1};
			delete this.PROJECTILE;
		} else
			this.action= {use:1|4, give:32, show:1, discard:1};
	};

/*
Weapon: 8,
Projectile: 16,
Scroll: 32,
Spell: 64,
Technique: 128,
Coin: 256,
Key: 512
	this.GEAR = {
		HEAD:  1,
		TORSO: 2, ARMOUR:2,
		RIGHTARM:4, WEAPON:4,
		LEFTARM:8, SHIELD:8,
		LEGS: 16,
		FEET: 32,
		HALO: 64
	};
*/

	this.ArmourItem = function(name, properties){
		inject.call(this, new that.GenericItem(name), '=');
		this.equipped = "";
		// When equipped raises
		this.ENHANCE = { attack:0, defense: 1, speed:0, agility:0, };
		// When thrown/used
		this.gear = this.GEAR.ARMOUR;

		inject.call(this, properties, '=');
		this.name = name;
		this.type = "Armour";
		if(this.unique)
			this.action= {equip:1|4, give:32, show:1};
		else
			this.action= {equip:1|4, "throw":1|4, give:32, show:1, discard:1};
	}

	this.WeaponItem = function(name, properties){
		inject.call(this, new that.GenericItem(name), '=');
		this.equipped = "";
		this.ENHANCE = { attack:1, defense: 0, speed:0, agility:0, };
		this.ATTACK = { damage: 5 };
		this.gear = this.GEAR.WEAPON;

		inject.call(this, properties, '=');
		this.name = name;
		this.type = "Weapon";
		if(this.unique)
			this.action= {equip:1|4, "attack":8, give:32, show:1};
		else
			this.action= {equip:1|4, "attack":8, give:32, show:1, discard:1};

	}
};


/*

// mcore
delete this.desc;var ITEM = new ITEMEngine();

ITEM.RegisterItem( ITEM.FoodItem, 'apple', { STATS:{hp:5, ki:700} });
ITEM.RegisterItem( ITEM.FoodItem, 'apple', { STATS:{hp:5, ki:100} });
ITEM.RegisterItem( ITEM.FoodItem, 'golden apple', { STATS:{hp:25, ki:25}, desc:"This golden apple will replenish you" });
ITEM.RegisterItem( ITEM.FoodItem, 'banana', {health:5});
ITEM.RegisterItem( ITEM.GenericItem, 'rusty key', {});
var B = {};
ITEM.addBackpack(B, 'rusty key');
//ITEM.addBackpack(B, 'banana');
ITEM.addBackpack(B, 'golden apple');
LL.write("BACKPACK="+FoldObj(B));
Abort("OK")
B['banana'].health=9;
LL.write("ITEMLIST="+FoldObj(ITEM.LIST));

// mcore
PARTY = {
	money: 1000,
	gametime: 0,
	BACKPACK:{
		weight: 100,
		maxweight:5000,
	},
	BACKPACKITEM: {
		'pear': {equipped:0, amount:2, that:ITEM.LIST['apple']},
	},
	PERSON: new Object()
};

PARTY.PERSON['Jack'] = new PersonObj( {name: 'Jack', STATS:{max:{ki:500}}, GEAR:{HEAD:ITEM.LIST['bandana']} } );

ITEM.addBackpack(PARTY.BACKPACKITEM, 'apple');
ITEM.Action.eat(PARTY.BACKPACKITEM.apple, PARTY.PERSON.Jack);
//LL.write(FoldObj(PARTY.PERSON));
LL.write(FoldObj(PARTY));


*/
